<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WPH_update
        {
            var $wph;
                                  
            function __construct()
                {
                    global $wph;
                    $this->wph          =   &$wph;
                    
                    $this->_run();
                }
                
                
            private function _run()
                {                    
                    $version        =   isset($this->wph->settings['version']) ?   $this->wph->settings['version'] :   1;
                    
                    //make sure the WPH_VERSION constant is being defined, 
                    //this issue occoured in version 1.3.9
                    //We set this for 1.3.9 as this is the code version whcih included the issue, all other version include the correnct data
                    if(!defined('WPH_VERSION')  &&  defined('WPH_MULOADER'))
                        {
                            define('WPH_VERSION',   '1.3.9');
                            
                            //attempt to copy over the new version of wp-hide-loader.php
                            WPH_functions::copy_mu_loader( TRUE );
                            
                        }
                    
                    
                    if (version_compare($version, WPH_CORE_VERSION, '<')) 
                        {
                            //keep track of flushed rules to avoid doing it multiple times
                            $_triggered_flush_rules   =   FALSE;
                            
                            if(version_compare($version, '1.1', '<'))
                                {
                                    //structure and settings fields where changed since v1.1
                                    if( isset($this->wph->settings['module_settings']['rewrite_new_theme_path']) )
                                        {
                                            $module_settings    =   $this->wph->settings['module_settings'];
                                            $this->wph->settings['module_settings'] =   array();
                                          
                                            foreach($module_settings    as  $key    =>  $value)
                                                {
                                                    if(strpos($key, 'rewrite_') !== FALSE &&    strpos($key, 'rewrite_') ==  0)
                                                        $key    =   substr($key,    8);
                                                        
                                                    if(strpos($key, 'general_') !== FALSE &&    strpos($key, 'general_') ==  0)
                                                        $key    =   substr($key,    8);
                                                        
                                                    if(strpos($key, 'admin_') !== FALSE &&    strpos($key, 'admin_') ==  0)
                                                        $key    =   substr($key,    6);
                                                        
                                                    $key    =   trim($key);
                                                    if(empty($key))
                                                        continue;
                                                    
                                                    $this->wph->settings['module_settings'][$key]   =   $value;
                                                }
                                        }
                                    
                                    $version =   '1.1';
                                }
                            
                                                    
                            if(version_compare($version, '1.3', '<'))
                                {
                                    //flush rules
                                    if( !   $_triggered_flush_rules )
                                        {
                                            add_action('wp_loaded',        array($this,    'flush_rules') , -1); 
                                            $_triggered_flush_rules =   TRUE;
                                        }
                                    
                                    $version =   '1.3';
                                }
                    
                            
                            if(version_compare($version, '1.3.2', '<'))
                                {
                                    //flush rules
                                    if( !   $_triggered_flush_rules )
                                        {
                                            add_action('wp_loaded',        array($this,    'flush_rules') , -1); 
                                            $_triggered_flush_rules =   TRUE;
                                        }
                                    
                                    $version =   '1.3.2';
                                }
                                
                            if(version_compare($version, '1.3.2.2', '<'))
                                {
                                    if(isset($this->wph->settings['module_settings']['remove_version']) &&  $this->wph->settings['module_settings']['remove_version']   ==  "yes")
                                        {
                                            $this->wph->settings['module_settings']['styles_remove_version']        =   'yes';
                                            $this->wph->settings['module_settings']['scripts_remove_version']       =   'yes';
                                            
                                            unset($this->wph->settings['module_settings']['remove_version']);   
                                        }
                                                                        
                                    $version =   '1.3.2.2';
                                }
                            
                            /**
                            * Create the environemnt file    
                            */
                            if(version_compare($version, '1.4', '<'))
                                {
                                    
                                    
                                    //copy over the new mu-loader version
                                    WPH_functions::copy_mu_loader( TRUE );
                                    
                                    if( !   $_triggered_flush_rules )
                                        {
                                            add_action('wp_loaded',        array($this,    'flush_rules') , -1); 
                                            $_triggered_flush_rules =   TRUE;
                                        }
                                    
                                    $version =   '1.4';
                                    
                                }
                                
                            /**
                            * Update the environemnt file and mu loader    
                            */
                            if(version_compare($version, '1.4.1', '<'))
                                {
                                    
                                    
                                    //copy over the new mu-loader version
                                    WPH_functions::copy_mu_loader( TRUE );
                                    
                                    
                                    $version =   '1.4.1';                    
                                }
                                
                            if(version_compare($version, '1.4.2', '<'))
                                {
                                    
                                    //unlink the router folder and inner files
                                    if( file_exists(WPH_PATH . '/router' ))
                                        {
                                            if( file_exists(WPH_PATH . '/router/file-process.php' ))
                                                @unlink ( WPH_PATH . '/router/file-process.php' );
                                            if( file_exists(WPH_PATH . '/router/environment.php' ))
                                                @unlink ( WPH_PATH . '/router/environment.php' );
                                                
                                            @rmdir( WPH_PATH . '/router' );
                                        }
                                    
                                    if( !   $_triggered_flush_rules )
                                        {
                                            add_action('wp_loaded',        array($this,    'flush_rules') , -1); 
                                            $_triggered_flush_rules =   TRUE;
                                        }
                                    
                                    
                                    $version =   '1.4.2';                    
                                }    
                            
                            
                            //save the last code version
                            $this->wph->settings['version'] =   WPH_CORE_VERSION;
                            $this->wph->functions->update_settings($this->wph->settings);
                                    
                        }
                    
                     
                }
            
 
            /**
            * Regenerate rewrite rules
            * 
            */
            function flush_rules()
                {
                    /** WordPress Misc Administration API */
                    require_once(ABSPATH . 'wp-admin/includes/misc.php');
                    
                    /** WordPress Administration File API */
                    require_once(ABSPATH . 'wp-admin/includes/file.php');
                    
                    flush_rewrite_rules();
                    
                    //clear the cache for W3 Cache              
                    if (function_exists('w3tc_pgcache_flush'))
                        w3tc_pgcache_flush();
                    
                    //recheck if permalinks where saved sucessfully and redirect
                    
                    /**
                    * ToDo Possible not necesarely?  
                    * 1) Through AJAX, plugin update - it trigger the first update so flush_rules()
                    * 2) Through regular plugin update, no new plugin files are being run
                    */
                    if( !defined( 'DOING_AJAX' ) &&  $this->wph->permalinks_not_applied   === FALSE   &&  $this->wph->functions->rewrite_rules_applied()  === TRUE)
                        {
                            //reload the page
                            wp_redirect($this->wph->functions->get_current_url());
                            die();
                        }
                          
                }
                
        }
        
        
?>